On May 4th, 2025, Erico Patricio Monteiro posted an "artifact color" demo image 
(which I've included in this archive) of something he was working on, on the
Facebook "TRS-80 Color Computer (CoCo)" group:

    (see https://www.facebook.com/share/p/1K4ym3a4P9/)

Intrigued, I asked:

    "I'm curious as to what mode allows this; it doesn't look like 
     PMODE4 - but it also doesn't look like some of the other modes, 
     either...but I know it's possible, because I recall other games 
     "back in the day" that did have artifact colors like this.

     Maybe I'm misremembering; I mean, PMODE4 can do red/blue/white/
     black (with the red/blue being the artifact colors, and halving 
     the horizontal res) - and then there's the other "screen mode" 
     that allowed for black, green, and a weird shade of grey and pur-
     ple-ish (???).

     But I don't think I ever played with getting (what looks like in 
     this picture), orange, black, blue, green, purple...I recall a 
     mode with white, cyan, magenta, and black (???) - I'm unsure about 
     the fourth color there.

     Can you "whip up" a simple demo showing some of these modes, and 
     color swatches, in BASIC (just some squares with the "colors") - 
     like I said, I recall these kinds of patterns/artifacts/etc (I 
     think CoCo Max had some of them as part of it's "palette")...?

     Or - if you know of something like that which already exists some-
     where...I'm just curious about this..."

He replied (and I'm paraphrasing a bit) that it was PMODE 4, and that CoCo Max 
did use such patterns, but that he didn't have any kind of code to generate the
patterns.

So...I scratched my own itch, so to speak, and I wrote this bit of BASIC code.
If you take a look at the "screenshot" (which I took from the online XRoar emu-
lator, which I what I wrote the program in/on) - you'll see it generates an 8x6
"patchwork" of "artifact squares" - ok, some are patterns, many are uninterest-
ing, but you should see, after a few runs - some interesting colorful ones. And
while I don't think it'll generate certain ones directly, if you watch along the
vertical edges of each patch, sometimes there will be a surprising "color" - I'm
sure it could be replicated as a patch, but I don't think my code is sophisti-
cated enough to do it as-is. But - if you change the mode (in emulation) to 
"black and white" (or on a real machine, turn off the colorburst) - you'll see
the actual black and white dots that should generate the "color" - something you
may want to play with.

The code is simple enough to follow, I believe, so I won't go into any detail on
it.

Run it on your favorite emulator - or real machine; if using an emulator, make
sure you pick the video settings to be NTSC and show/emulate NTSC artifact col-
ors; if using real hardware, you'll need to use a television or composite moni-
tor, or set your video system to render such "colors" on whatever display you
are using.

I hope you enjoy seeing this as much as I did in creating it; it was a fun lit-
tle diversion for me, and a bit of nostalgia as well.

Andrew L. Ayers @ May 4th, 2025
